/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import com.mojang.blaze3d.vertex.VertexConsumer;
import icyllis.modernui.graphics.MathUtil;
import icyllis.modernui.graphics.text.Font;
import icyllis.modernui.mc.text.BitmapFont;
import icyllis.modernui.mc.text.EffectRenderType;
import icyllis.modernui.mc.text.GLBakedGlyph;
import icyllis.modernui.mc.text.GlyphManager;
import icyllis.modernui.mc.text.ModernTextRenderer;
import icyllis.modernui.mc.text.TextLayoutEngine;
import icyllis.modernui.mc.text.TextLayoutProcessor;
import icyllis.modernui.mc.text.TextRenderEffect;
import icyllis.modernui.mc.text.TextRenderType;
import icyllis.modernui.util.SparseArray;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;

public class TextLayout {
    private static final Random RANDOM = new Random();
    public static final TextLayout EMPTY = new TextLayout(new char[0], new int[0], new float[0], null, new Font[0], new float[0], new int[0], new int[]{0}, 0.0f, false, false, 2, -1){

        @Override
        @Nonnull
        TextLayout get() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean tick(int lifespan) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float drawText(@Nonnull Matrix4f matrix, @Nonnull MultiBufferSource source, float x, float top, int r, int g, int b, int a, boolean isShadow, int preferredMode, boolean polygonOffset, float uniformScale, int bgColor, int packedLight) {
            return 0.0f;
        }

        @Override
        public void drawTextOutline(@Nonnull Matrix4f matrix, @Nonnull MultiBufferSource source, float x, float top, int r, int g, int b, int a, int packedLight) {
        }
    };
    public static final int STANDARD_BASELINE_OFFSET = 7;
    public static float sBaselineOffset = 7.0f;
    private final char[] mTextBuf;
    private final int[] mGlyphs;
    private transient GLBakedGlyph[] mBakedGlyphs;
    private transient GLBakedGlyph[] mBakedGlyphsForSDF;
    private transient SparseArray<GLBakedGlyph[]> mBakedGlyphsArray;
    private final float[] mPositions;
    private final byte[] mFontIndices;
    private final Font[] mFonts;
    private final float[] mAdvances;
    private final int[] mGlyphFlags;
    private final int[] mLineBoundaries;
    private final float mTotalAdvance;
    private final boolean mHasEffect;
    private final boolean mHasColorEmoji;
    final int mCreatedResLevel;
    final int mComputedFlags;
    private transient int mTimer = 0;

    private TextLayout(@Nonnull TextLayout layout) {
        this.mTextBuf = layout.mTextBuf;
        this.mGlyphs = layout.mGlyphs;
        this.mPositions = layout.mPositions;
        this.mFontIndices = layout.mFontIndices;
        this.mFonts = layout.mFonts;
        this.mAdvances = layout.mAdvances;
        this.mGlyphFlags = layout.mGlyphFlags;
        this.mLineBoundaries = layout.mLineBoundaries;
        this.mTotalAdvance = layout.mTotalAdvance;
        this.mHasEffect = layout.mHasEffect;
        this.mHasColorEmoji = layout.mHasColorEmoji;
        this.mCreatedResLevel = layout.mCreatedResLevel;
        this.mComputedFlags = layout.mComputedFlags;
    }

    TextLayout(@Nonnull char[] textBuf, @Nonnull int[] glyphs, @Nonnull float[] positions, @Nullable byte[] fontIndices, @Nonnull Font[] fonts, @Nullable float[] advances, @Nonnull int[] glyphFlags, @Nullable int[] lineBoundaries, float totalAdvance, boolean hasEffect, boolean hasColorEmoji, int createdResLevel, int computedFlags) {
        this.mTextBuf = textBuf;
        this.mGlyphs = glyphs;
        this.mPositions = positions;
        this.mFontIndices = fontIndices;
        this.mFonts = fonts;
        this.mAdvances = advances;
        this.mGlyphFlags = glyphFlags;
        this.mLineBoundaries = lineBoundaries;
        this.mTotalAdvance = totalAdvance;
        this.mHasEffect = hasEffect;
        this.mHasColorEmoji = hasColorEmoji;
        this.mCreatedResLevel = createdResLevel;
        this.mComputedFlags = computedFlags;
        assert (this.mAdvances == null || this.mTextBuf.length == this.mAdvances.length);
        assert (this.mGlyphs.length * 2 == this.mPositions.length);
        assert (this.mGlyphs.length == this.mGlyphFlags.length);
    }

    @Nonnull
    public static TextLayout makeEmpty() {
        return new TextLayout(EMPTY);
    }

    @Nonnull
    TextLayout get() {
        this.mTimer = 0;
        return this;
    }

    boolean tick(int lifespan) {
        return ++this.mTimer > lifespan;
    }

    @Nonnull
    private GLBakedGlyph[] prepareGlyphs(int fontSize) {
        GlyphManager glyphManager = GlyphManager.getInstance();
        GLBakedGlyph[] glyphs = new GLBakedGlyph[this.mGlyphs.length];
        for (int i = 0; i < glyphs.length; ++i) {
            glyphs[i] = (this.mGlyphFlags[i] & 0x10000000) != 0 ? glyphManager.lookupFastChars(this.getFont(i), fontSize, this.mGlyphs[i]) : glyphManager.lookupGlyph(this.getFont(i), fontSize, this.mGlyphs[i]);
        }
        return glyphs;
    }

    @Nonnull
    private GLBakedGlyph[] getGlyphs(int resLevel) {
        if (resLevel == this.mCreatedResLevel) {
            if (this.mBakedGlyphs == null) {
                int fontSize = TextLayoutProcessor.computeFontSize(resLevel);
                this.mBakedGlyphs = this.prepareGlyphs(fontSize);
            }
            return this.mBakedGlyphs;
        }
        if (this.mBakedGlyphsForSDF == null) {
            int fontSize = TextLayoutProcessor.computeFontSize(resLevel);
            this.mBakedGlyphsForSDF = this.prepareGlyphs(fontSize);
        }
        return this.mBakedGlyphsForSDF;
    }

    @Nonnull
    private GLBakedGlyph[] getGlyphsUniformScale(float density) {
        int fontSize;
        GLBakedGlyph[] glyphs;
        if (this.mBakedGlyphsArray == null) {
            this.mBakedGlyphsArray = new SparseArray();
        }
        if ((glyphs = this.mBakedGlyphsArray.get(fontSize = TextLayoutProcessor.computeFontSize(density))) == null) {
            glyphs = this.prepareGlyphs(fontSize);
            this.mBakedGlyphsArray.put(fontSize, glyphs);
        }
        return glyphs;
    }

    public float drawText(@Nonnull Matrix4f matrix, @Nonnull MultiBufferSource source, float x, float top, int r, int g, int b, int a, boolean isShadow, int preferredMode, boolean polygonOffset, float uniformScale, int bgColor, int packedLight) {
        int i;
        float density;
        GLBakedGlyph[] glyphs;
        int startR = r;
        int startG = g;
        int startB = b;
        if (preferredMode == 1) {
            int resLevel = TextLayoutEngine.adjustPixelDensityForSDF(this.mCreatedResLevel);
            glyphs = this.getGlyphs(resLevel);
            density = resLevel;
        } else if (preferredMode == 4) {
            if (uniformScale <= 0.001f) {
                return this.mTotalAdvance;
            }
            density = (float)this.mCreatedResLevel * uniformScale;
            glyphs = this.getGlyphsUniformScale(density);
            preferredMode = 0;
        } else {
            glyphs = this.getGlyphs(this.mCreatedResLevel);
            density = this.mCreatedResLevel;
        }
        float invDensity = 1.0f / density;
        float shadowOffset = 0.0f;
        if (isShadow) {
            shadowOffset = ModernTextRenderer.sShadowOffset;
            if (preferredMode == 0) {
                shadowOffset = (float)Math.round(shadowOffset * density) * invDensity;
            }
            x += shadowOffset;
            top += shadowOffset;
        }
        float[] positions = this.mPositions;
        int[] flags = this.mGlyphFlags;
        float baseline = top + sBaselineOffset;
        int prevTexture = -1;
        int prevMode = -1;
        Font.DisplayMode prevVanillaDisplayMode = null;
        VertexConsumer builder = null;
        int fontTexture = -1;
        boolean seeThrough = preferredMode == 3;
        int e = glyphs.length;
        for (i = 0; i < e; ++i) {
            int mode;
            float h;
            float w;
            float ry;
            float rx;
            int texture;
            GLBakedGlyph glyph = glyphs[i];
            if (glyph == null) continue;
            int bits = flags[i];
            boolean fakeItalic = false;
            int ascent = 0;
            Font.DisplayMode vanillaDisplayMode = null;
            boolean isBitmapFont = false;
            if ((bits & 0x10000000) != 0) {
                GlyphManager.FastCharSet chars = (GlyphManager.FastCharSet)glyph;
                int fastIndex = RANDOM.nextInt(chars.glyphs.size());
                glyph = chars.glyphs.get(fastIndex);
            }
            if ((bits & 0x60000000) != 0) {
                float scaleFactor;
                Font font = this.getFont(i);
                if (font instanceof BitmapFont) {
                    BitmapFont bitmapFont = (BitmapFont)font;
                    texture = GlyphManager.getInstance().getCurrentTexture(bitmapFont);
                    ascent = bitmapFont.getAscent();
                    scaleFactor = 0.125f;
                    isBitmapFont = true;
                } else {
                    assert ((bits & 0x20000000) != 0);
                    if (isShadow) continue;
                    texture = GlyphManager.getInstance().getEmojiTexture();
                    ascent = 7;
                    scaleFactor = TextLayoutProcessor.sBaseFontSize / 64.0f;
                }
                fakeItalic = (bits & 0x2000000) != 0;
                rx = x + positions[i << 1] + (float)glyph.x * scaleFactor;
                ry = baseline + positions[i << 1 | 1] + (float)glyph.y * scaleFactor;
                if (isShadow) {
                    rx += 1.0f - shadowOffset;
                    ry += 1.0f - shadowOffset;
                }
                w = (float)glyph.width * scaleFactor;
                h = (float)glyph.height * scaleFactor;
                int n = mode = seeThrough ? preferredMode : 0;
                if (isBitmapFont) {
                    Font.DisplayMode displayMode = vanillaDisplayMode = seeThrough ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL;
                }
                if (polygonOffset) {
                    vanillaDisplayMode = Font.DisplayMode.POLYGON_OFFSET;
                }
            } else {
                mode = preferredMode;
                rx = x + positions[i << 1] + (float)glyph.x * invDensity;
                ry = baseline + positions[i << 1 | 1] + (float)glyph.y * invDensity;
                w = (float)glyph.width * invDensity;
                h = (float)glyph.height * invDensity;
                if (fontTexture == -1) {
                    fontTexture = GlyphManager.getInstance().getFontTexture();
                }
                texture = fontTexture;
            }
            if (preferredMode == 0) {
                rx = (float)Math.round(rx * density) * invDensity;
                ry = (float)Math.round(ry * density) * invDensity;
            }
            if ((bits & Integer.MIN_VALUE) != 0) {
                r = startR;
                g = startG;
                b = startB;
            } else {
                r = bits >> 16 & 0xFF;
                g = bits >> 8 & 0xFF;
                b = bits & 0xFF;
                if (isShadow) {
                    r >>= 2;
                    g >>= 2;
                    b >>= 2;
                }
            }
            if (builder == null || prevTexture != texture || prevMode != mode || prevVanillaDisplayMode != vanillaDisplayMode) {
                prevTexture = texture;
                prevMode = mode;
                prevVanillaDisplayMode = vanillaDisplayMode;
                builder = source.m_6299_((RenderType)(vanillaDisplayMode != null ? TextRenderType.getOrCreate(texture, vanillaDisplayMode, isBitmapFont) : TextRenderType.getOrCreate(texture, mode)));
            }
            float upSkew = 0.0f;
            float downSkew = 0.0f;
            if (fakeItalic) {
                upSkew = 0.25f * (float)ascent;
                downSkew = 0.25f * ((float)ascent - h);
            }
            builder.m_252986_(matrix, rx + upSkew, ry, 0.0f).m_6122_(r, g, b, a).m_7421_(glyph.u1, glyph.v1).m_85969_(packedLight).m_5752_();
            builder.m_252986_(matrix, rx + downSkew, ry + h, 0.0f).m_6122_(r, g, b, a).m_7421_(glyph.u1, glyph.v2).m_85969_(packedLight).m_5752_();
            builder.m_252986_(matrix, rx + w + downSkew, ry + h, 0.0f).m_6122_(r, g, b, a).m_7421_(glyph.u2, glyph.v2).m_85969_(packedLight).m_5752_();
            builder.m_252986_(matrix, rx + w + upSkew, ry, 0.0f).m_6122_(r, g, b, a).m_7421_(glyph.u2, glyph.v1).m_85969_(packedLight).m_5752_();
        }
        builder = null;
        if (this.mHasEffect) {
            builder = source.m_6299_((RenderType)EffectRenderType.getRenderType(seeThrough, polygonOffset));
            e = glyphs.length;
            for (i = 0; i < e; ++i) {
                int bits = flags[i];
                if ((bits & 0xC000000) == 0) continue;
                if ((bits & Integer.MIN_VALUE) != 0) {
                    r = startR;
                    g = startG;
                    b = startB;
                } else {
                    r = bits >> 16 & 0xFF;
                    g = bits >> 8 & 0xFF;
                    b = bits & 0xFF;
                    if (isShadow) {
                        r >>= 2;
                        g >>= 2;
                        b >>= 2;
                    }
                }
                float rx1 = x + positions[i << 1];
                float rx2 = x + (i + 1 == e ? this.mTotalAdvance : positions[i + 1 << 1]);
                if ((bits & 0x8000000) != 0) {
                    TextRenderEffect.drawStrikethrough(matrix, builder, rx1, rx2, baseline, r, g, b, a, packedLight);
                }
                if ((bits & 0x4000000) == 0) continue;
                TextRenderEffect.drawUnderline(matrix, builder, rx1, rx2, baseline, r, g, b, a, packedLight);
            }
        }
        if ((bgColor & 0xFF000000) != 0) {
            if (builder == null) {
                builder = source.m_6299_((RenderType)EffectRenderType.getRenderType(seeThrough, polygonOffset));
            }
            builder.m_252986_(matrix, x - 1.0f, top + 9.0f, 0.01f).m_193479_(bgColor).m_7421_(0.0f, 1.0f).m_85969_(packedLight).m_5752_();
            builder.m_252986_(matrix, x + this.mTotalAdvance + 1.0f, top + 9.0f, 0.01f).m_193479_(bgColor).m_7421_(1.0f, 1.0f).m_85969_(packedLight).m_5752_();
            builder.m_252986_(matrix, x + this.mTotalAdvance + 1.0f, top - 1.0f, 0.01f).m_193479_(bgColor).m_7421_(1.0f, 0.0f).m_85969_(packedLight).m_5752_();
            builder.m_252986_(matrix, x - 1.0f, top - 1.0f, 0.01f).m_193479_(bgColor).m_7421_(0.0f, 0.0f).m_85969_(packedLight).m_5752_();
        }
        return this.mTotalAdvance;
    }

    public void drawTextOutline(@Nonnull Matrix4f matrix, @Nonnull MultiBufferSource source, float x, float top, int r, int g, int b, int a, int packedLight) {
        float resLevel = TextLayoutEngine.adjustPixelDensityForSDF(this.mCreatedResLevel);
        GLBakedGlyph[] glyphs = this.getGlyphs((int)resLevel);
        float[] positions = this.mPositions;
        int[] flags = this.mGlyphFlags;
        float baseline = top + sBaselineOffset;
        int prevTexture = -1;
        VertexConsumer builder = null;
        int fontTexture = -1;
        float sBloat = 1.0f / resLevel;
        int e = glyphs.length;
        for (int i = 0; i < e; ++i) {
            int bits;
            GLBakedGlyph glyph = glyphs[i];
            if (glyph == null || ((bits = flags[i]) & 0x60000000) != 0) continue;
            if ((bits & 0x10000000) != 0) {
                GlyphManager.FastCharSet chars = (GlyphManager.FastCharSet)glyph;
                int fastIndex = RANDOM.nextInt(chars.glyphs.size());
                glyph = chars.glyphs.get(fastIndex);
            }
            float rx = x + positions[i << 1] + (float)glyph.x / resLevel;
            float ry = baseline + positions[i << 1 | 1] + (float)glyph.y / resLevel;
            float w = (float)glyph.width / resLevel;
            float h = (float)glyph.height / resLevel;
            if (fontTexture == -1) {
                fontTexture = GlyphManager.getInstance().getFontTexture();
            }
            int texture = fontTexture;
            if (builder == null || prevTexture != texture) {
                prevTexture = texture;
                builder = source.m_6299_((RenderType)TextRenderType.getOrCreate(prevTexture, 2));
            }
            float uBloat = (glyph.u2 - glyph.u1) / (float)glyph.width;
            float vBloat = (glyph.v2 - glyph.v1) / (float)glyph.height;
            builder.m_252986_(matrix, rx - sBloat, ry - sBloat, 0.001f).m_6122_(r, g, b, a).m_7421_(glyph.u1 - uBloat, glyph.v1 - vBloat).m_85969_(packedLight).m_5752_();
            builder.m_252986_(matrix, rx - sBloat, ry + h + sBloat, 0.001f).m_6122_(r, g, b, a).m_7421_(glyph.u1 - uBloat, glyph.v2 + vBloat).m_85969_(packedLight).m_5752_();
            builder.m_252986_(matrix, rx + w + sBloat, ry + h + sBloat, 0.0f).m_6122_(r, g, b, a).m_7421_(glyph.u2 + uBloat, glyph.v2 + vBloat).m_85969_(packedLight).m_5752_();
            builder.m_252986_(matrix, rx + w + sBloat, ry - sBloat, 0.0f).m_6122_(r, g, b, a).m_7421_(glyph.u2 + uBloat, glyph.v1 - vBloat).m_85969_(packedLight).m_5752_();
        }
    }

    @Nonnull
    public char[] getTextBuf() {
        return this.mTextBuf;
    }

    @Nonnull
    public int[] getGlyphs() {
        return this.mGlyphs;
    }

    @Nonnull
    public float[] getPositions() {
        return this.mPositions;
    }

    public float[] getAdvances() {
        return this.mAdvances;
    }

    public Font getFont(int i) {
        if (this.mFontIndices != null) {
            return this.mFonts[this.mFontIndices[i] & 0xFF];
        }
        return this.mFonts[0];
    }

    public int getCharCount() {
        return this.mTextBuf.length;
    }

    @Nonnull
    public int[] getGlyphFlags() {
        return this.mGlyphFlags;
    }

    @Nullable
    public byte[] getFontIndices() {
        return this.mFontIndices;
    }

    public Font[] getFontVector() {
        return this.mFonts;
    }

    public int[] getLineBoundaries() {
        return this.mLineBoundaries;
    }

    public float getTotalAdvance() {
        return this.mTotalAdvance;
    }

    public boolean hasEffect() {
        return this.mHasEffect;
    }

    public boolean hasColorEmoji() {
        return this.mHasColorEmoji;
    }

    public int getMemorySize() {
        int m = 0;
        m += 16 + MathUtil.align8(this.mTextBuf.length << 1);
        m += 16 + MathUtil.align8(this.mGlyphs.length << 2);
        m += 16 + MathUtil.align8(this.mPositions.length << 2);
        if (this.mFontIndices != null) {
            m += 16 + MathUtil.align8(this.mFontIndices.length);
        }
        m += 16 + MathUtil.align8(this.mFonts.length << 2);
        if (this.mAdvances != null) {
            m += 16 + MathUtil.align8(this.mAdvances.length << 2);
        }
        m += 16 + MathUtil.align8(this.mGlyphFlags.length << 2);
        if (this.mLineBoundaries != null) {
            m += 16 + MathUtil.align8(this.mLineBoundaries.length << 2);
        }
        if (this.mBakedGlyphs != null) {
            m += 16 + MathUtil.align8(this.mBakedGlyphs.length << 2);
        }
        if (this.mBakedGlyphsForSDF != null) {
            m += 16 + MathUtil.align8(this.mBakedGlyphsForSDF.length << 2);
        }
        if (this.mBakedGlyphsArray != null) {
            m += (16 + MathUtil.align8(this.mBakedGlyphsArray.valueAt(0).length << 2)) * this.mBakedGlyphsArray.size();
        }
        return m + 64;
    }

    public String toString() {
        return "TextLayout{text=" + TextLayout.toEscapeChars(this.mTextBuf) + ",glyphs=" + this.mGlyphs.length + ",length=" + this.mTextBuf.length + ",positions=" + TextLayout.toPositionString(this.mPositions) + ",advances=" + Arrays.toString(this.mAdvances) + ",charFlags=" + TextLayout.toFlagString(this.mGlyphFlags) + ",lineBoundaries=" + Arrays.toString(this.mLineBoundaries) + ",totalAdvance=" + this.mTotalAdvance + ",hasEffect=" + this.mHasEffect + ",hasColorEmoji=" + this.mHasColorEmoji + "}";
    }

    @Nonnull
    public String toDetailedString() {
        StringBuilder b = new StringBuilder();
        char[] chars = this.mTextBuf;
        b.append("chars: ").append(chars.length).append('\n');
        float[] advances = this.mAdvances;
        int[] lineBoundaries = this.mLineBoundaries;
        int lineBoundaryIndex = 0;
        int nextLineBoundary = lineBoundaries != null ? lineBoundaries[lineBoundaryIndex++] : -1;
        int i = 0;
        while (i < chars.length) {
            int j;
            b.append(String.format(" %04X ", i));
            int lim = Math.min(i + 8, chars.length);
            for (j = i; j < lim; ++j) {
                b.append(String.format("\\u%04X", chars[j]));
            }
            if (advances != null) {
                b.append("\n      ");
                for (j = i; j < lim; ++j) {
                    b.append(String.format(" %5.1f", Float.valueOf(advances[j])));
                }
            }
            if (advances != null || lineBoundaries != null) {
                b.append("\n      ");
                for (j = i; j < lim; ++j) {
                    if (j == nextLineBoundary) {
                        b.append("LB    ");
                        nextLineBoundary = lineBoundaries[lineBoundaryIndex++];
                        continue;
                    }
                    if (advances != null && advances[j] != 0.0f) {
                        b.append("GB    ");
                        continue;
                    }
                    b.append("NB    ");
                }
            }
            b.append('\n');
            i = lim;
        }
        int[] glyphs = this.mGlyphs;
        b.append("glyphs: ").append(glyphs.length).append('\n');
        float[] positions = this.mPositions;
        byte[] fontIndices = this.mFontIndices;
        int[] glyphFlags = this.mGlyphFlags;
        int i2 = 0;
        while (i2 < glyphs.length) {
            int j;
            b.append(String.format(" %04X ", i2));
            int lim = Math.min(i2 + 4, glyphs.length);
            for (j = i2; j < lim; ++j) {
                int idx = fontIndices == null ? 0 : fontIndices[j] & 0xFF;
                b.append(String.format(" %02X %02X %04X ", idx, glyphs[j] >>> 24, glyphs[j] & 0xFFFF));
            }
            b.append("\n      ");
            for (j = i2; j < lim; ++j) {
                b.append(String.format("%6.1f,%4.1f ", Float.valueOf(positions[j << 1]), Float.valueOf(positions[j << 1 | 1])));
            }
            b.append("\n      ");
            for (j = i2; j < lim; ++j) {
                b.append(' ');
                TextLayout.toFlagString(b, glyphFlags[j]);
                b.append("    ");
            }
            b.append('\n');
            i2 = lim;
        }
        Font[] fonts = this.mFonts;
        for (int i3 = 0; i3 < fonts.length; ++i3) {
            b.append(String.format(" %02X: %s\n", i3, fonts[i3].getFamilyName()));
        }
        b.append("total advance: ");
        b.append(this.mTotalAdvance);
        b.append(", created res level: ");
        b.append(this.mCreatedResLevel);
        return b.toString();
    }

    @Nonnull
    private static String toEscapeChars(@Nonnull char[] a) {
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append("\\u");
            String s = Integer.toHexString(a[i]);
            b.append("0".repeat(4 - s.length()));
            b.append(s);
            if (i == iMax) {
                return b.toString();
            }
            ++i;
        }
    }

    @Nonnull
    private static String toPositionString(@Nonnull float[] a) {
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append('(');
            b.append(a[i++]);
            b.append(',');
            b.append(a[i]);
            b.append(')');
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    @Nonnull
    private static String toFlagString(@Nonnull int[] a) {
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append("0x");
            b.append(Integer.toHexString(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(" ");
            ++i;
        }
    }

    public static void toFlagString(StringBuilder b, int flag) {
        if ((flag & 0x1000000) != 0) {
            b.append('B');
        } else {
            b.append(' ');
        }
        if ((flag & 0x2000000) != 0) {
            b.append('I');
        } else {
            b.append(' ');
        }
        if ((flag & 0x4000000) != 0) {
            b.append('U');
        } else {
            b.append(' ');
        }
        if ((flag & 0x8000000) != 0) {
            b.append('S');
        } else {
            b.append(' ');
        }
        if ((flag & 0x10000000) != 0) {
            b.append('O');
        } else {
            b.append(' ');
        }
        if ((flag & 0x20000000) != 0) {
            b.append('E');
        } else {
            b.append(' ');
        }
        if ((flag & 0x40000000) != 0) {
            b.append('M');
        } else {
            b.append(' ');
        }
    }
}

